﻿using StokYonetimSistemi.DataAccess;
using System.Linq; // SequenceEqual metodu için bu gereklidir.
using System.Security.Cryptography;
using System.Text;
// using System.Collections; // Artık StructuralComparisons kullanmadığımız için bu satır gereksiz.

namespace StokYonetimSistemi.Business
{
    public class KullaniciManager
    {
        public bool KullaniciDogrula(string kullaniciAdi, string sifre)
        {
            using (var context = new StokYonetimDbContext())
            {
                var kullanici = context.Kullanicilar.FirstOrDefault(k => k.KullaniciAdi == kullaniciAdi);

                // Kullanıcı bulunamadıysa veya veritabanında şifresi kayıtlı değilse, başarısız dön.
                if (kullanici == null || kullanici.SifreHash == null)
                {
                    return false;
                }

                // Girilen şifreyi hash'le.
                byte[] girilenSifreHash = SifreHashle(sifre);

                // Veritabanındaki hash ile kullanıcının girdiği şifrenin hash'ini karşılaştır.
                // SequenceEqual, iki byte dizisinin içeriğinin birebir aynı olup olmadığını kontrol eder.
                return kullanici.SifreHash.SequenceEqual(girilenSifreHash);
            }
        }
        // Bu metot, şifreleri SHA256 ile hash'lemek için kullanılır.
        // Dışarıdan çağrılmasına gerek olmadığı için 'private' olması daha doğrudur.
        private byte[] SifreHashle(string sifre)
        {
            using (SHA256 sha256 = SHA256.Create())
            {
                // String'i byte dizisine çevir ve hash'ini al.
                return sha256.ComputeHash(Encoding.UTF8.GetBytes(sifre));
            }
        }
    }
}